//+------------------------------------------------------------------+
//|											 #The Forex Freedom Bars
//|														 
//+------------------------------------------------------------------+
#property copyright "Programmed by Eli hayun"
#property indicator_separate_window
#property indicator_minimum 0.5
#property indicator_maximum 5
#property indicator_buffers 8
#property indicator_color1 DodgerBlue
#property indicator_color2 Red
#property indicator_color3 DodgerBlue
#property indicator_color4 Red
#property indicator_color5 DodgerBlue
#property indicator_color6 Red
#property indicator_color7 DodgerBlue
#property indicator_color8 Red

//---- buffers
double buf4_up[];
double buf4_down[];
double buf3_up[];
double buf3_down[];
double buf2_up[];
double buf2_down[];
double buf1_up[];
double buf1_down[];

extern int TF1 = PERIOD_M5;//M15
extern int TF2 = PERIOD_M15;//M30
extern int TF3 = PERIOD_M30;//H1
extern int TF4 = PERIOD_H1;//H4

extern int cci_1	 = 2;//50
extern int cci_2	 = 2;//14
extern int cci_3	 = 2;
extern int cci_4	 = 2;

extern bool AutoDisplay		= true;

string shortname = "";

//+------------------------------------------------------------------+
//| Custom indicator initialization function						 |
//+------------------------------------------------------------------+
int init()
{
	SetAutoDisplay();
	shortname = "# FX Freedom("+TF1+","+TF2+","+TF3+","+TF4+")";
	
	IndicatorShortName(shortname);
//---- indicators
	SetIndexStyle(0,DRAW_ARROW);
	SetIndexArrow(0,110);
	SetIndexBuffer(0,buf4_up);
	SetIndexEmptyValue(0,0.0);
	SetIndexStyle(1,DRAW_ARROW);
	SetIndexArrow(1,110);
	SetIndexBuffer(1,buf4_down);
	SetIndexEmptyValue(1,0.0);
	SetIndexStyle(2,DRAW_ARROW);
	SetIndexArrow(2,110);
	SetIndexBuffer(2,buf3_up);
	SetIndexEmptyValue(2,0.0);
	SetIndexStyle(3,DRAW_ARROW);
	SetIndexArrow(3,110);
	SetIndexBuffer(3,buf3_down);
	SetIndexEmptyValue(3,0.0);
	SetIndexStyle(4,DRAW_ARROW);
	SetIndexArrow(4,110);
	SetIndexBuffer(4,buf2_up);
	SetIndexEmptyValue(4,0.0);
	SetIndexStyle(5,DRAW_ARROW);
	SetIndexArrow(5,110);
	SetIndexBuffer(5,buf2_down);
	SetIndexEmptyValue(5,0.0);
	SetIndexStyle(6,DRAW_ARROW);
	SetIndexArrow(6,110);
	SetIndexBuffer(6,buf1_up);
	SetIndexEmptyValue(6,0.0);
	SetIndexStyle(7,DRAW_ARROW);
	SetIndexArrow(7,110);
	SetIndexBuffer(7,buf1_down);
	SetIndexEmptyValue(7,0.0);
//----
	return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function						 |
//+------------------------------------------------------------------+
int deinit()
{
	int win=WindowFind(shortname);
	string txt;
	int i;
	for (i=0; i<4; i++) {
		switch (i)	{
			case 0: txt = tf2txt(TF1); break;
			case 1: txt = tf2txt(TF2); break;
			case 2: txt = tf2txt(TF3); break;
			case 3: txt = tf2txt(TF4); break;
		}
		ObjectDelete("FF_"+win+"_"+i+"_"+txt);
	}//----
	return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function								 |
//+------------------------------------------------------------------+
int start()
{
	int	 counted_bars=IndicatorCounted();
	int i,j,k;
	int barmax;
	if (counted_bars>0) counted_bars--;
	int limit=Bars-counted_bars;

	datetime TimeArray_4[], TimeArray_3[], TimeArray_2[], TimeArray_1[];
	double h,l,tp,tpma;
//----
	int win = WindowFind(shortname);//UniqueNum; // 
	for (i=0; i<4; i++) {
		string txt = "??";
		double gp;
		switch (i)	{
			case 0: txt = tf2txt(TF1);  gp = 1.2 + i; break;
			case 1: txt = tf2txt(TF2);  gp = 1.2 + i; break;
			case 2: txt = tf2txt(TF3);  gp = 1.2 + i; break;
			case 3: txt = tf2txt(TF4);  gp = 1.2 + i; break;
		}
		string name = "FF_"+win+"_"+i+"_"+txt;
		if (ObjectFind(name) == -1) {
			ObjectCreate(name, OBJ_TEXT, WindowFind(shortname), iTime(NULL,0,0)+Period()*180, gp);
			ObjectSetText(name, txt,8,"Arial", Silver);
		} else {
			ObjectMove(name,0,iTime(NULL,0,0)+Period()*180,gp);
		}
	}
	ArrayCopySeries(TimeArray_1,MODE_TIME,Symbol(),TF1);
	ArrayCopySeries(TimeArray_2,MODE_TIME,Symbol(),TF2);
	ArrayCopySeries(TimeArray_3,MODE_TIME,Symbol(),TF3);
	ArrayCopySeries(TimeArray_4,MODE_TIME,Symbol(),TF4);

	if (TF1 == Period()) {
		for (i=limit;i>=0;i--) {
			if (iCCI(NULL,0,cci_1,PRICE_TYPICAL,i)>0) {
				buf1_up[i] = 1;buf1_down[i] = 0;
			} else {
				buf1_up[i] = 0;buf1_down[i] = 1;
			}
		}
	} else if (TF1>Period()) {
		barmax=iBars(NULL,TF1);
		if (TimeArray_1[barmax-1-cci_1]>Time[limit]) {
			for (i=barmax*(TF1/Period());Time[i]<TimeArray_1[barmax-1-cci_1];i--) {
				//;
			}
			limit=i;
		}
		j=limit;
		for (i=limit;i>=0;i--) {
			while (Time[i]>=TimeArray_1[j]+(TimeArray_1[0]-TimeArray_1[1]) && j>0) {
				j--;
			}
			h=High[i];
			l=Low[i];
			for (k=i;Time[k]>=TimeArray_1[j];k++) {
				if (h<High[k]) h=High[k];
				if (l>Low[k]) l=Low[k];
			}
			tp=(h+l+Close[i])/3;
			tpma=iMA(NULL,TF1,cci_1-1,0,MODE_SMA,PRICE_TYPICAL,j+1);
			if (tp > tpma) {
				buf1_up[i] = 1; buf1_down[i] = 0;
			} else {
				buf1_up[i] = 0; buf1_down[i] = 1;
			}
		}
	}

	if (TF2 == Period()) {
		for (i=limit;i>=0;i--) {
			if (iCCI(NULL,0,cci_2,PRICE_TYPICAL,i)>0) {
				buf2_up[i] = 2;buf2_down[i] = 0;
			} else {
				buf2_up[i] = 0;buf2_down[i] = 2;
			}
		}
	} else if (TF2>Period()) {
		barmax=iBars(NULL,TF2);
		if (TimeArray_2[barmax-1-cci_2]>Time[limit]) {
			for (i=barmax*(TF2/Period());Time[i]<TimeArray_2[barmax-1-cci_2];i--) {
				//;
			}
			limit=i;
		}
		j=limit;
		for (i=limit;i>=0;i--) {
			while (Time[i]>=TimeArray_2[j]+(TimeArray_2[0]-TimeArray_2[1]) && j>0) {
				j--;
			}
			h=High[i];
			l=Low[i];
			for (k=i;Time[k]>=TimeArray_2[j];k++) {
				if (h<High[k]) h=High[k];
				if (l>Low[k]) l=Low[k];
			}
			tp=(h+l+Close[i])/3;
			tpma=iMA(NULL,TF2,cci_2-1,0,MODE_SMA,PRICE_TYPICAL,j+1);
			if (tp > tpma) {
				buf2_up[i] = 2; buf2_down[i] = 0;
			} else {
				buf2_up[i] = 0; buf2_down[i] = 2;
			}
		}
	}

	if (TF3 == Period()) {
		for (i=limit;i>=0;i--) {
			if (iCCI(NULL,0,cci_3,PRICE_TYPICAL,i)>0) {
				buf3_up[i] = 3;buf3_down[i] = 0;
			} else {
				buf3_up[i] = 0;buf3_down[i] = 3;
			}
		}
	} else if (TF3>Period()) {
		barmax=iBars(NULL,TF3);
		if (TimeArray_3[barmax-1-cci_3]>Time[limit]) {
			for (i=barmax*(TF3/Period());Time[i]<TimeArray_3[barmax-1-cci_3];i--) {
				//;
			}
			limit=i;
		}
		j=limit;
		for (i=limit;i>=0;i--) {
			while (Time[i]>=TimeArray_3[j]+(TimeArray_3[0]-TimeArray_3[1]) && j>0) {
				j--;
			}
			h=High[i];
			l=Low[i];
			for (k=i;Time[k]>=TimeArray_3[j];k++) {
				if (h<High[k]) h=High[k];
				if (l>Low[k]) l=Low[k];
			}
			tp=(h+l+Close[i])/3;
			tpma=iMA(NULL,TF3,cci_3-1,0,MODE_SMA,PRICE_TYPICAL,j+1);
			if (tp > tpma) {
				buf3_up[i] = 3; buf3_down[i] = 0;
			} else {
				buf3_up[i] = 0; buf3_down[i] = 3;
			}
		}
	}

	if (TF4 == Period()) {
		for (i=limit;i>=0;i--) {
			if (iCCI(NULL,0,cci_4,PRICE_TYPICAL,i)>0) {
				buf4_up[i] = 4;buf4_down[i] = 0;
			} else {
				buf4_up[i] = 0;buf4_down[i] = 4;
			}
		}
	} else if (TF4>Period()) {
		barmax=iBars(NULL,TF4);
		if (TimeArray_4[barmax-1-cci_4]>Time[limit]) {
			for (i=barmax*(TF4/Period());Time[i]<TimeArray_4[barmax-1-cci_4];i--) {
				//;
			}
			limit=i;
		}
		j=limit;
		for (i=limit;i>=0;i--) {
			while (Time[i]>=TimeArray_4[j]+(TimeArray_4[0]-TimeArray_4[1]) && j>0) {
				j--;
			}
			h=High[i];
			l=Low[i];
			for (k=i;Time[k]>=TimeArray_4[j];k++) {
				if (h<High[k]) h=High[k];
				if (l>Low[k]) l=Low[k];
			}
			tp=(h+l+Close[i])/3;
			tpma=iMA(NULL,TF4,cci_4-1,0,MODE_SMA,PRICE_TYPICAL,j+1);
			if (tp > tpma) {
				buf4_up[i] = 4; buf4_down[i] = 0;
			} else {
				buf4_up[i] = 0; buf4_down[i] = 4;
			}
		}
	}

	return(0);
}
//+------------------------------------------------------------------+

string tf2txt(int tf)
{
	if (tf == PERIOD_M1)	 return("M1");
	if (tf == PERIOD_M5)	 return("M5");
	if (tf == PERIOD_M15)	 return("M15");
	if (tf == PERIOD_M30)	 return("M30");
	if (tf == PERIOD_H1)	 return("H1");
	if (tf == PERIOD_H4)	 return("H4");
	if (tf == PERIOD_D1)	 return("D1");
	if (tf == PERIOD_W1)	 return("W1");
	if (tf == PERIOD_MN1)	 return("MN1");
	
	return("??");
}

void SetValues(int p1, int p2, int p3, int p4)
{
	TF1 = p1;	TF2 = p2; TF3 = p3; TF4 = p4; 
}

void SetAutoDisplay()
{
	if (AutoDisplay) {
		switch (Period()) {
			case PERIOD_M1  :  SetValues(PERIOD_M1,  PERIOD_M5, PERIOD_M15,PERIOD_M30); break;
			case PERIOD_M5  :  SetValues(PERIOD_M5,  PERIOD_M15,PERIOD_M30,PERIOD_H1); break;
			case PERIOD_M15 :  SetValues(PERIOD_M5,  PERIOD_M15,PERIOD_M30,PERIOD_H1); break;
			case PERIOD_M30 :  SetValues(PERIOD_M5, PERIOD_M15,PERIOD_M30, PERIOD_H1); break;
			case PERIOD_H1  :  SetValues(PERIOD_M15, PERIOD_M30,PERIOD_H1, PERIOD_H4);  break;
			case PERIOD_H4  :  SetValues(PERIOD_M30, PERIOD_H1, PERIOD_H4, PERIOD_D1);  break;
			case PERIOD_D1  :  SetValues(PERIOD_H1,  PERIOD_H4, PERIOD_D1, PERIOD_W1); break;
			case PERIOD_W1  :  SetValues(PERIOD_H4,  PERIOD_D1, PERIOD_W1,PERIOD_MN1); break;
			case PERIOD_MN1 :  SetValues(PERIOD_H4,  PERIOD_D1, PERIOD_W1,PERIOD_MN1);  break;
		}
	}
	
}

